//
// Path Array.js
//
//  v.100122
//  required version : Cheetah3D v5.3
//
//  (c) 2010 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 2010-01-22 first
// 2010-01-29 optimized.
//
// Usage: Place this into scripts/Polygonobj folder. restart Cheetah3D, then select this script from Tools -> Scritp -> Polygon Script
//

var randoms = new Array;
var copy_randoms = new Array;
var randoms_pos = new Array;
var randoms_dis = new Array;
var random_count = 1000;
var count_max = 40000;

var splHolder = new Array;
var splList = new Array;

function buildUI(obj){
    var normalType, normalAngle;
    
    obj.setParameter("name","Path Array");
    
    obj.addParameterInt("count",10,1,count_max,true,true);
    
    obj.addParameterBool("rotate along normal",1,0,1,true,true);
    
    obj.addParameterSelector("copy type", ["random", "static"], true, true);
    obj.addParameterSelector("poly selection", ["child's index", "child's polysel"], true, true);
    
    obj.addParameterSeparator("Path Settings");
    obj.addParameterInt("sub path num",0,0,1000,true,true);
	obj.addParameterSelector("path position",["random","static"],true,true);
	
    obj.addParameterSeparator("Array Settings");
    
    obj.addParameterBool("random distance",0,0,1,true,true);
    
    obj.addParameterFloat("distance",0,-1000,1000,true,true);
    obj.addParameterFloat("distance path-scale",1,0,100,true,true);
    
    obj.addParameterBool("random angle",0,0,1,true,true);
    obj.addParameterFloat("angle H",0,-10000,10000,true,true);
    obj.addParameterFloat("angle P",0,-10000,10000,true,true);
    obj.addParameterFloat("angle B",0,-10000,10000,true,true);
    obj.addParameterFloat("path-angle",1,0,100,true,true);
    
    obj.addParameterBool("random scale",0,0,1,true,true);
    obj.addParameterBool("keep proportion",1,0,1,true,true);
    obj.addParameterFloat("scale amount X",0,-1000,1000,true,true);
    obj.addParameterFloat("scale amount Y",0,-1000,1000,true,true);
    obj.addParameterFloat("scale amount Z",0,-1000,1000,true,true);
    obj.addParameterFloat("path-scale",1,0,100,true,true);
    
    obj.addParameterBool("make as creator",0,0,1,true,true);
    
    obj.addParameterButton("update","Update","objectUpdate");
    
    obj.setParameter("normalType",2);
    obj.setParameter("normalAngle",45.0);
    
    obj.addParameterSeparator("Smooth");
    obj.addParameterSelector("smooth",["normalFlat","normalPhong","normalContraint", "normalBreak"],true,true);
    obj.addParameterFloat("smooth angle", 45.0, 5.0, 90.0, true, true);
    
    obj.setParameter("smooth",2);
}

function objectUpdate(obj) {
    obj.update();
}

function copyCoreToVertex(core, cCore, cMat, posV, scaleV, rotV, cPos, cRot, iter, polysel_type) {
    var i, j;
    var polyCount = cCore.polygonCount();
    var vertexCount = cCore.vertexCount();
    
    var trans = new Mat4D(TRANSLATE,posV.x,posV.y,posV.z);
    var scale = new Mat4D(SCALE,scaleV.x,scaleV.y,scaleV.z);
    var rot = new Mat4D(ROTATE_HPB,rotV.x,rotV.y,rotV.z);
    
    var cmPos = new Mat4D(TRANSLATE,cPos.x,cPos.y,cPos.z);
    var cmRot = new Mat4D(ROTATE_HPB,cRot.x,cRot.y,cRot.z);

    for (i = 0;i < vertexCount;i++) {
        var vert = cmPos.multiply( rot.multiply( cmRot.multiply( scale.multiply( cMat.multiply(cCore.vertex(i)) ) ) ) );
        vert = trans.multiply( vert );
        core.addVertex(false, vert);
    }
    for (i = 0;i < polyCount;i++) {
        var size = cCore.polygonSize(i);
        var verts = new Array;
        var uvs = new Array;
        for (j = 0;j < size;j++) {
            verts[j] = cCore.vertexIndex(i, j)+(iter);
			var uv = cCore.uvCoord(i,j);
            uvs[j] = new Vec2D(uv.x, uv.y);
        }
        var pi = core.addIndexPolygon(size, verts, uvs);
	    if (polysel_type == null) {
			for (var bi = 0;bi < 16;bi++) {
				cCore.setActivePolygonSelection( bi );
				core.setActivePolygonSelection( bi );
				core.setPolygonSelection( pi, cCore.polygonSelection( i ) );
			}
	    } else {
	    	core.setActivePolygonSelection( polysel_type );
	    	core.setPolygonSelection( pi, true );
	    }
    }
}

function buildObject(obj){
    var core = obj.core();
    var i,j,k;
    
    var alignNormal = obj.getParameter("rotate along normal");
    
    var count = obj.getParameter("count");
    
    var pathpos = parseInt( obj.getParameter("path position") );
    var variation = obj.getParameter("random distance");
    var rand_angle = obj.getParameter("random angle");
    var rand_scale = obj.getParameter("random scale");
    
    var distance = obj.getParameter("distance");
    var distance_scale = obj.getParameter("distance path-scale");
    
    var rotx = obj.getParameter("angle H");
    var roty = obj.getParameter("angle P");
    var rotz = obj.getParameter("angle B");
    var path_rot = obj.getParameter("path-angle");
    
    var proportion = obj.getParameter("keep proportion");
    var path_scale = obj.getParameter("path-scale");
    var scalex = obj.getParameter("scale amount X");
    var scaley = obj.getParameter("scale amount Y");
    var scalez = obj.getParameter("scale amount Z");
    
    var copytype = parseInt(obj.getParameter("copy type"));
    var polysel = parseInt(obj.getParameter("poly selection"));
    
    var subpath = obj.getParameter("sub path num");
    
    if (obj.getParameter("make as creator")) {
        obj.setCreatorObj( true );
    }
    
    //print("----- Polygon Array -----");
    
    if (obj.childCount() > 1) {
        var base = obj.childAtIndex(0);
        var guide = obj.childAtIndex(1);
        var baseCore_list = [];
        var baseMat_list = [];
        
        if ( guide.family() == SPLINEFAMILY && ( base.family() == NGONFAMILY || base.type() == FOLDER ) ) {
            // smooth
            obj.setParameter("normalType",obj.getParameter("smooth"),false);
            obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
            
            // getting base polyCore
            var guideCore = guide.modCore();
            var guideMat = guide.objMatrix();
            
            if (guideCore.pathCount() > subpath) {
            	spl = guideCore.cache( subpath );
            	if (spl != null) {
            		splHolder = spl;
            		cacheSplineLength();
            	}
            } else {
            	print('no sub path detected');
            	return;
            }
            
            var base_index;
            var baseCore;
            var baseMat;
            
            if (base.type() == FOLDER) {
            	if (base.childCount() < 1) return;
            	
            	for (i = 0;i < base.childCount();i++) {
            		var base_child = base.childAtIndex(i);
            		
            		if (base_child.family() == NGONFAMILY) {
            			baseCore_list.push( base_child.modCore() );
            			baseMat_list.push( base_child.objMatrix() );
            		}
            	}
            } else {
            	baseCore_list.push( base.modCore() );
            	baseMat_list.push( base.objMatrix() );
            }
            
            //OS.system("echo list:"+baseCore_list+':'+baseMat_list);
            
            // error check
            if (baseCore_list.length < 0) return;
            var base_count = baseCore_list.length;
            
            if (! randoms.length) {
                for (i = 0;i < random_count;i++) {
                    randoms[i] = [ Math.random(), Math.random(), Math.random() ];
                    copy_randoms[i] = Math.random();
                }
            }
            
            if (! randoms_pos.length) {
            	for (i = 0;i < count_max;i++) {
            		randoms_pos[i] = Math.random();
            		randoms_dis[i] = Math.random();
            	}
            }
            //print("copy count:"+guidePolyCount);
            
            for (i = 0;i < count;i++) {
            	
                var random_i = i % random_count;
                var gScale = new Vec3D(1,1,1);
                
                if ( pathpos == 0) {
                	var pers = randoms_pos[ i ];
                	
                } else {
                	var pers = i / (count - 1);
                	
                }
                var distance_so = distance + ( distance * (( distance_scale - 1 ) * pers) );
				
				var gVert = pointFromPercentage( pers, guideMat );
				
				if ( pers + 0.01 > 1) {
					var gVert_sub = pointFromPercentage( pers - 0.01, guideMat );
					var gNormal_pos = gVert.sub( gVert_sub );
				} else {
					var gVert_sub = pointFromPercentage( pers + 0.01, guideMat );
					var gNormal_pos = gVert_sub.sub( gVert );
				}
				
                var gNormal = gNormal_pos.multiply( 1/ gNormal_pos.norm() );
                
                var theta = Math.acos(gNormal.y)*180/Math.PI;
                var phi = Math.atan2(gNormal.x,gNormal.z)*180/Math.PI;
                
                var gRot_pos = new Vec3D(phi,theta,0);
                var gRot_mat = new Mat4D(ROTATE_HPB, gRot_pos.x, gRot_pos.y, gRot_pos.z);
                
                if (alignNormal == 1) {
                    var gRot = gRot_pos.copy();
                } else {
                    var gRot = new Vec3D(0,0,0);
                }
                
                if (variation) {
                    var cPos = new Vec3D(Math.sin(randoms[random_i][0]*Math.PI*2)*distance_so*randoms_dis[i], 0, Math.cos(randoms[random_i][0]*Math.PI*2)*distance_so*randoms_dis[i]);
                    cPos = gRot_mat.multiply( cPos );
                } else {
                    var cPos = new Vec3D(Math.cos(randoms[random_i][1]*Math.PI*2)*distance_so, 0, Math.sin(randoms[random_i][1]*Math.PI*2)*distance_so);
                    cPos = gRot_mat.multiply( cPos );
                }
                
                if (rand_angle) {
                    var cRot = new Vec3D(randoms[random_i][0]*rotx/2-rotx/2, randoms[random_i][1]*roty/2-roty/2, randoms[random_i][2]*rotz/2-rotz/2);
                } else {
                    var cRot = new Vec3D(rotx, roty, rotz);
                }
                
                if (rand_scale) {
                    if (proportion) gScale = gScale.add(new Vec3D(randoms[random_i][1]*scalex, randoms[random_i][1]*scalex, randoms[random_i][1]*scalex));
                    else gScale = gScale.add(new Vec3D(randoms[random_i][0]*scalex, randoms[random_i][1]*scaley, randoms[random_i][2]*scalez));
                } else {
                    if (proportion) gScale = gScale.add(new Vec3D(scalex, scalex, scalex));
                    else gScale = gScale.add(new Vec3D(scalex, scaley, scalez));
                }
                
                cRot = cRot.add( cRot.multiply( (path_rot - 1) * pers ) );
                gScale = gScale.add( gScale.multiply( (path_scale - 1) * pers ) );
                
                base_index = null;
                
                if (copytype) {
                	base_index = i % base_count;
                } else {
	                base_index = Math.floor( copy_randoms[random_i] * base_count );
	            }
                
                if (base_index == null) continue;
                
                baseCore = baseCore_list[ base_index ];
                baseMat = baseMat_list[ base_index ];
                
                //OS.system("echo "+ base_index + ', ' + baseCore + ': ' + baseMat + ': ' + i );
                
                var polysel_type = (polysel)? null : base_index;
                
                if (polysel_type > 15) polysel_type = 0;
                
                copyCoreToVertex(core, baseCore, baseMat, gVert, gScale, gRot, cPos, cRot, core.vertexCount(), polysel_type);
            }
        }
    }
}

function pointFromPercentage(percent, mat) { // these spline stuff from Todd's Loft.js
    if (percent < 0 && percent > 1) return new Vec3D(0,0,0);
    var i; var hi = splHolder.length - 1; var lo = 0;
    var d = percent;
    while (hi - lo > 1) {
        i = Math.floor((hi+lo)/2);
        if (percent <= splList[i]) {
            hi = i;
            continue;
        }
        if (percent > splList[i]) {
            lo = i;
        }
    }
    i = hi;
    
    var p1 = splHolder[i-1];
    var p2 = splHolder[i];
    //
    d = (d - splList[i-1])/(splList[i] - splList[i-1]);
    p1 = p1.multiply(1-d).add(p2.multiply(d));
    return mat.multiply(p1);
}

function cacheSplineLength() {
    var l = splHolder.length;
    var i;

    var accum = 0;
    splList[0] = 0;
    for (i = 0;i < l - 1;i++) {
        var p = splHolder[i+1].sub(splHolder[i]);
        accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
        splList[i+1] = accum;
    }
    for (i = 0;i < l;i++) {
        splList[i] = splList[i] / accum;
    }
}

